package net.kldp.logviewer.common.config;

import net.kldp.logviewer.common.cache.SimpleCache;
import net.kldp.logviewer.common.log.LogViews;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;


/**
 * <PRE>
 * 		Title : ȯ  ϰ  ϴ Ŭ ̴.
 * 
 * 		Comment : 
 * 
 * 		History : 	
 * 				
 * </PRE>
 * 
 * @version  0.1, 2005. 7. 27.
 * @author 	Henry
 */
public class CommonConfig {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LogViews.getLogger(CommonConfig.class);

	/**
	 * ȯ  ִ 
	 */
	protected static String propName = "main.properties";
	
	/**
	 * ȯ  ̸ شϴ Ű Ѱش.
	 * 
	 * @param name
	 * @return
	 */
	public static String getWentProp(String name) {
		String value = "";
		
		try {
		    SimpleCache _simpleCache = SimpleCache.getCache();
			
		    // SimpleCache  ?
		    value = _simpleCache.getPropBox(name);
			
		    // SimpleCache   Cache ϰ Ѵ.
			if(value.equals("")) {
				PropertiesConfiguration config = new PropertiesConfiguration();				
				config.load(CommonConfig.class.getResourceAsStream(propName));
				
				value = config.getString(name);
				
				// cache ȯ Ѵ.
				_simpleCache.setPropBox(name, value);
			}
		} catch (ConfigurationException cf) {
			cf.printStackTrace();
			logger.error("CommonConfig  ߿ ", cf);
		}
		
		return value;
	}
	
	/**
	 * ȯ  Ÿ boolean ȯѴ.
	 * @param name
	 * @return
	 */
	public static boolean getWentPropBool(String name) {
		return new Boolean(getWentProp(name)).booleanValue();		
	}
	
	/**
	 * ȯ  Ÿ int ȯѴ.
	 * @param name
	 * @return
	 */
	public static int getWentPropInt(String name) {
		return new Integer(getWentProp(name)).intValue();		
	}
	
	
	
}
